package inc.monsters.mias.data;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class KidsList { 
	private List<Kid> kids;

	private static final String[] firstNames = { "Aaliyah", "Aaron", "Abbey",
			"Abbie", "Abby", "Abel", "Abigail", "Abraham", "Adam", "Adan",
			"Addison", "Aden", "Adrian", "Adriana", "Adrianna", "Adrienne",
			"Ahmad", "Aidan", "Aiden", "Aimee", "Aine", "Aisling", "Al",
			"Alaina", "Alan", "Alana", "Alanna", "Alannah", "Alayna", "Albert",
			"Alberto", "Alec", "Alejandra", "Alejandro", "Alex", "Alex",
			"Alexa", "Alexander", "Alexandra", "Alexandria", "Alexia",
			"Alexis", "Alexis", "Alexus", "Alfie", "Alfonso", "Alfred",
			"Alfredo", "Ali", "Alice", "Alicia", "Alina", "Alisa", "Alisha",
			"Alison", "Alissa", "Alivia", "Aliyah", "Allan", "Allen", "Allie",
			"Allison", "Allyson", "Alma", "Alondra", "Alonzo", "Alphonso",
			"Alton", "Alvin", "Alyson", "Alyssa", "Amanda", "Amari", "Amari",
			"Amaya", "Amber", "Amelia", "Amelie", "America", "Amir", "Amy",
			"Amya", "Ana", "Anahi", "Anastasia", "Andre", "Andrea", "Andres",
			"Andrew", "Andy", "Angel", "Angel", "Angela", "Angelia",
			"Angelica", "Angelina", "Angelo", "Angie", "Angus", "Anita",
			"Aniya", "Aniyah", "Ann", "Anna", "Annabelle", "Anne", "Annette",
			"Annie", "Annika", "Annmarie", "Anthony", "Antoinette", "Antonio",
			"Anya", "Aoibhe", "Aoife", "April", "Archie", "Ariana", "Arianna",
			"Ariel", "Arlene", "Armando", "Arnold", "Arthur", "Arturo",
			"Ashanti", "Asher", "Ashlee", "Ashleigh", "Ashley", "Ashlyn",
			"Ashlynn", "Ashton", "Ashton", "Asia", "Aubrey", "Audra", "Audrey",
			"Aurora", "Austin", "Autumn", "Ava", "Avery", "Avery", "Axel",
			"Ayanna", "Ayden", "Bailey", "Bailey", "Barbara", "Barry", "Bart",
			"Baylee", "Beatrice", "Beau", "Becky", "Belinda", "Bella", "Ben",
			"Benita", "Benjamin", "Bennett", "Bennie", "Benny", "Bernadette",
			"Bernard", "Bernice", "Bert", "Bertha", "Beth", "Bethany", "Betsy",
			"Betty", "Beverly", "Bianca", "Bill", "Billie", "Billy", "Blaine",
			"Blake", "Bob", "Bobbi", "Bobbie", "Bobby", "Bonita", "Bonnie",
			"Boo", "Boyd", "Brad", "Braden", "Bradford", "Bradley", "Brady",
			"Braeden", "Branden", "Brandon", "Braxton", "Brayan", "Brayden",
			"Braydon", "Breanna", "Brenda", "Brendan", "Brenden", "Brendon",
			"Brenna", "Brennan", "Brent", "Bret", "Brett", "Brian", "Briana",
			"Brianna", "Bridget", "Bridgette", "Britney", "Brittany",
			"Brittney", "Brock", "Brody", "Brooke", "Brooklyn", "Brooklynn",
			"Bruce", "Bryan", "Bryanna", "Bryant", "Bryce", "Brynn", "Bryon",
			"Bryson", "Buddy", "Byron", "Cade", "Caden", "Cadence", "Caitlin",
			"Caitlyn", "Caleb", "Callie", "Callum", "Calum", "Calvin",
			"Camden", "Cameron", "Cameron", "Camila", "Camille", "Camron",
			"Camryn", "Candace", "Candy", "Caoimhe", "Cara", "Carey",
			"Carissa", "Carl", "Carla", "Carley", "Carlos", "Carlton", "Carly",
			"Carmen", "Carol", "Carole", "Carolina", "Caroline", "Carolyn",
			"Carrie", "Carson", "Carter", "Cary", "Casey", "Casey",
			"Cassandra", "Cassidy", "Cathal", "Catherine", "Cathleen", "Cathy",
			"Cayden", "Cecelia", "Cecil", "Cecilia", "Cedric", "Celeste",
			"Celia", "Cesar", "Chad", "Chance", "Chandler", "Charlene",
			"Charles", "Charlie", "Charlotte", "Chase", "Chelsea", "Cheri",
			"Cherie", "Cheryl", "Chester", "Cheyanne", "Cheyenne", "Chloe",
			"Chris", "Chris", "Christi", "Christian", "Christie", "Christina",
			"Christine", "Christopher", "Christy", "Chuck", "Cian", "Ciara",
			"Ciaran", "Cierra", "Cillian", "Cindy", "Claire", "Clara",
			"Clarence", "Clarissa", "Clark", "Claude", "Claudia", "Clay",
			"Clayton", "Clifford", "Clifton", "Clint", "Clinton", "Clodagh",
			"Clyde", "Cody", "Colby", "Cole", "Colette", "Colin", "Colleen",
			"Collin", "Colm", "Colton", "Conner", "Connie", "Connor", "Conor",
			"Conrad", "Constance", "Cooper", "Cora", "Corbin", "Corey",
			"Corinne", "Cormac", "Cornelius", "Cory", "Courtney", "Craig",
			"Cristian", "Cristina", "Crystal", "Curt", "Curtis", "Cynthia",
			"Daire", "Daisy", "Dakota", "Dakota", "Dale", "Dallas", "Dalton",
			"Damian", "Damien", "Damion", "Damon", "Dan", "Dana", "Dana",
			"Dane", "Danette", "Daniel", "Daniela", "Daniella", "Danielle",
			"Danny", "Dante", "Daphne", "Dara", "Daragh", "Darcy", "Darcy",
			"Daren", "Darian", "Darin", "Darius", "Darla", "Darlene",
			"Darnell", "Darragh", "Darrel", "Darrell", "Darren", "Darrin",
			"Darryl", "Darwin", "Daryl", "Dave", "David", "Davion", "Davis",
			"Dawn", "Dawson", "Dean", "Deana", "Deandre", "Deann", "Deanna",
			"Deanne", "Debbie", "Debora", "Deborah", "Debra", "Declan", "Dee",
			"Deena", "Deidre", "Deirdre", "Deja", "Delaney", "Delbert",
			"Delia", "Della", "Delores", "Demetrius", "Demi", "Dena", "Denis",
			"Denise", "Dennis", "Derek", "Derrick", "Desiree", "Desmond",
			"Destinee", "Destiny", "Devin", "Devon", "Dewayne", "Dewey",
			"Dexter", "Diamond", "Diana", "Diane", "Dianna", "Dianne",
			"Diarmuid", "Diego", "Dillon", "Dina", "Dino", "Dion", "Dirk",
			"Dolores", "Dominic", "Dominick", "Dominique", "Don", "Donald",
			"Donna", "Donnie", "Donovan", "Dora", "Doreen", "Dorian", "Doris",
			"Dorothy", "Doug", "Douglas", "Doyle", "Drake", "Drew", "Duane",
			"Dulce", "Dustin", "Dwayne", "Dwight", "Dylan", "Eabha", "Earl",
			"Earnest", "Easton", "Ebony", "Ed", "Eddie", "Eden", "Edgar",
			"Edith", "Edmund", "Edna", "Eduardo", "Edward", "Edwin", "Eileen",
			"Eimear", "Elaina", "Elaine", "Eleanor", "Elena", "Eli", "Eliana",
			"Elias", "Elijah", "Elisa", "Elisabeth", "Elise", "Eliza",
			"Elizabeth", "Ella", "Ellen", "Ellie", "Elliot", "Elliott",
			"Ellis", "Elmer", "Eloise", "Emanuel", "Emely", "Emer", "Emilee",
			"Emiliano", "Emilie", "Emilio", "Emily", "Emma", "Emmanuel",
			"Enrique", "Eoghan", "Eoin", "Eric", "Erica", "Erick", "Erik",
			"Erika", "Erin", "Ernest", "Ernesto", "Ernie", "Ervin",
			"Esmeralda", "Esteban", "Esther", "Ethan", "Ethel", "Eugene",
			"Eva", "Evan", "Eve", "Evelyn", "Everett", "Evie", "Ewan",
			"Ezekiel", "Ezra", "Fabian", "Faith", "Fatima", "Faye", "Felicia",
			"Felipe", "Felix", "Fernanda", "Fernando", "Finlay", "Finley",
			"Finn", "Fiona", "Fionn", "Florence", "Floyd", "Forrest",
			"Frances", "Francesca", "Francine", "Francis", "Francisco",
			"Frank", "Frankie", "Franklin", "Fred", "Freddie", "Freddy",
			"Frederick", "Fredrick", "Freya", "Gabriel", "Gabriela",
			"Gabriella", "Gabrielle", "Gage", "Gail", "Garrett", "Garry",
			"Gary", "Gavin", "Gayle", "Gemma", "Gena", "Gene", "Genesis",
			"Genevieve", "Geoffrey", "George", "Georgia", "Gerald",
			"Geraldine", "Gerard", "Gerardo", "Gerry", "Gianna", "Gilbert",
			"Gilberto", "Gillian", "Gina", "Ginger", "Giovanni", "Giselle",
			"Gisselle", "Gladys", "Glen", "Glenda", "Glenn", "Gloria",
			"Gordon", "Grace", "Gracie", "Grady", "Graham", "Grant", "Grayson",
			"Greg", "Gregg", "Gregory", "Gretchen", "Griffin", "Guadalupe",
			"Guillermo", "Gustavo", "Guy", "Gwen", "Gwendolyn", "Hailee",
			"Hailey", "Haleigh", "Haley", "Halle", "Hallie", "Hamish", "Hanna",
			"Hannah", "Harley", "Harley", "Harold", "Harriet", "Harrison",
			"Harry", "Harvey", "Hayden", "Haylee", "Hayley", "Hazel",
			"Heather", "Heaven", "Hector", "Heidi", "Helen", "Henry",
			"Herbert", "Herman", "Holden", "Hollie", "Holly", "Homer", "Hope",
			"Horace", "Howard", "Hubert", "Hudson", "Hugh", "Hugo", "Hunter",
			"Ian", "Ida", "Imani", "Imogen", "India", "Ingrid", "Ira", "Irene",
			"Iris", "Irma", "Isaac", "Isabel", "Isabella", "Isabelle",
			"Isaiah", "Isiah", "Ismael", "Isobel", "Israel", "Issac", "Itzel",
			"Ivan", "Ivy", "Izabella", "Jace", "Jack", "Jackie", "Jackie",
			"Jackson", "Jacob", "Jacqueline", "Jacquelyn", "Jada", "Jade",
			"Jaden", "Jaden", "Jadon", "Jadyn", "Jai", "Jaiden", "Jaime",
			"Jake", "Jakob", "Jalen", "Jamal", "James", "Jamie", "Jamie",
			"Jan", "Jana", "Jane", "Janelle", "Janet", "Janette", "Janice",
			"Janie", "Janine", "Janis", "Jaqueline", "Jared", "Jarrett",
			"Jasmin", "Jasmine", "Jason", "Javier", "Javon", "Jaxon", "Jay",
			"Jayda", "Jayden", "Jayden", "Jayla", "Jaylen", "Jaylin", "Jaylon",
			"Jayne", "Jayson", "Jazmin", "Jazmine", "Jean", "Jeanette",
			"Jeanine", "Jeanne", "Jeannette", "Jeannie", "Jeannine", "Jeff",
			"Jeffery", "Jeffrey", "Jeffry", "Jenna", "Jennie", "Jennifer",
			"Jenny", "Jerald", "Jeremiah", "Jeremy", "Jeri", "Jermaine",
			"Jerome", "Jerri", "Jerry", "Jesse", "Jessica", "Jessie", "Jessie",
			"Jesus", "Jett", "Jill", "Jillian", "Jim", "Jimmie", "Jimmy", "Jo",
			"Joan", "Joann", "Joanna", "Joanne", "Joaquin", "Jocelyn", "Jodi",
			"Jodie", "Jody", "Jody", "Joe", "Joel", "Joey", "Johanna", "John",
			"Johnathan", "Johnathon", "Johnnie", "Johnny", "Jolene", "Jon",
			"Jonah", "Jonas", "Jonathan", "Jonathon", "Joni", "Jordan",
			"Jordan", "Jordyn", "Jorge", "Jorja", "Jose", "Joselyn", "Joseph",
			"Josephine", "Josh", "Joshua", "Josiah", "Josie", "Josue", "Joy",
			"Joyce", "Juan", "Juanita", "Jude", "Judith", "Judy", "Julia",
			"Julian", "Juliana", "Julianna", "Julianne", "Julie", "Julio",
			"Julissa", "Julius", "June", "Justice", "Justice", "Justin",
			"Kade", "Kaden", "Kai", "Kaiden", "Kailey", "Kaitlin", "Kaitlyn",
			"Kaitlynn", "Kaleb", "Kaleigh", "Kameron", "Kamryn", "Kara",
			"Karen", "Kari", "Karin", "Karina", "Karissa", "Karl", "Karla",
			"Karyn", "Kasey", "Kassandra", "Kassidy", "Kate", "Katelyn",
			"Katelynn", "Katherine", "Kathleen", "Kathryn", "Kathy", "Katie",
			"Katlyn", "Katrina", "Kay", "Kayden", "Kayla", "Kaylee",
			"Kayleigh", "Kaylie", "Kaylin", "Keaton", "Keegan", "Keira",
			"Keith", "Kelley", "Kelli", "Kellie", "Kelly", "Kelly", "Kelsey",
			"Kelvin", "Ken", "Kendall", "Kendall", "Kendra", "Kendrick",
			"Kennedy", "Kenneth", "Kenny", "Kent", "Keri", "Kerri", "Kerry",
			"Kerry", "Kevin", "Khalil", "Kian", "Kiana", "Kiara", "Kiera",
			"Kieran", "Kierra", "Kiersten", "Kiley", "Killian", "Kim", "Kim",
			"Kimberlee", "Kimberley", "Kimberly", "Kip", "Kira", "Kirk",
			"Kirsten", "Kobe", "Kody", "Kolby", "Kris", "Kris", "Krista",
			"Kristen", "Kristi", "Kristian", "Kristie", "Kristin", "Kristina",
			"Kristine", "Kristopher", "Kristy", "Krystal", "Kurt", "Kurtis",
			"Kyla", "Kyle", "Kylee", "Kyleigh", "Kyler", "Kylie", "Kyra",
			"Lacey", "Lachlan", "Ladonna", "Laila", "Lamar", "Lamont", "Lana",
			"Lance", "Landen", "Landon", "Lane", "Lara", "Larry", "Laura",
			"Laurel", "Lauren", "Laurence", "Lauri", "Laurie", "Lauryn",
			"Lawrence", "Layla", "Lea", "Leah", "Leann", "Leanne", "Lee",
			"Lee", "Leigh", "Leila", "Leilani", "Leland", "Lena", "Leo",
			"Leon", "Leona", "Leonard", "Leonardo", "Leroy", "Lesa", "Lesley",
			"Leslie", "Leslie", "Lesly", "Lester", "Leticia", "Levi", "Lewis",
			"Lexi", "Liam", "Libby", "Liliana", "Lillian", "Lillie", "Lilly",
			"Lily", "Linda", "Lindsay", "Lindsey", "Lionel", "Lisa", "Lizbeth",
			"Lloyd", "Logan", "Logan", "Lois", "Lola", "Lonnie", "Lora",
			"Loren", "Lorenzo", "Loretta", "Lori", "Lorie", "Lorna",
			"Lorraine", "Lorri", "Lorrie", "Louie", "Louis", "Louise",
			"Lowell", "Luann", "Luca", "Lucas", "Lucia", "Lucille", "Lucinda",
			"Lucy", "Luis", "Lukas", "Luke", "Luther", "Lydia", "Lyle",
			"Lynda", "Lynette", "Lynn", "Lynn", "Lynne", "Lynnette", "Macie",
			"Mack", "Mackenzie", "Macy", "Madalyn", "Maddison", "Madeleine",
			"Madeline", "Madelyn", "Madison", "Madisyn", "Madyson", "Maeve",
			"Maggie", "Maisie", "Makayla", "Makenna", "Makenzie", "Malachi",
			"Malcolm", "Malia", "Malik", "Mallory", "Manuel", "Marc",
			"Marcella", "Marci", "Marcia", "Marco", "Marcos", "Marcus",
			"Marcy", "Margaret", "Margarita", "Margie", "Margo", "Maria",
			"Mariah", "Marian", "Mariana", "Marianne", "Marie", "Marilyn",
			"Marina", "Mario", "Marion", "Marion", "Marisa", "Marisol",
			"Marissa", "Maritza", "Marjorie", "Mark", "Marla", "Marlene",
			"Marlon", "Marquis", "Marsha", "Marshall", "Martha", "Martin",
			"Marty", "Marvin", "Mary", "Maryann", "Marybeth", "Mason", "Mateo",
			"Mathew", "Matilda", "Matt", "Matthew", "Maureen", "Maurice",
			"Mauricio", "Max", "Maximilian", "Maximus", "Maxine", "Maxwell",
			"Maya", "Mckayla", "Mckenna", "Mckenzie", "Meagan", "Megan",
			"Meghan", "Mekhi", "Melanie", "Melinda", "Melissa", "Melody",
			"Melvin", "Mercedes", "Meredith", "Mia", "Micah", "Michael",
			"Michael", "Michaela", "Micheal", "Michele", "Michelle", "Mickey",
			"Miguel", "Mikaela", "Mikayla", "Mike", "Mildred", "Miles",
			"Millie", "Milton", "Mindy", "Miranda", "Miriam", "Misty",
			"Mitchell", "Mitzi", "Mohamed", "Mohammad", "Mohammed", "Moises",
			"Mollie", "Molly", "Mona", "Monica", "Monique", "Monte", "Monty",
			"Morgan", "Morgan", "Morris", "Moses", "Muhammad", "Mya", "Myles",
			"Myra", "Myron", "Nadia", "Nadine", "Nancy", "Nanette", "Naomi",
			"Nasir", "Natalia", "Natalie", "Natasha", "Nathan", "Nathanael",
			"Nathaniel", "Nayeli", "Neal", "Neil", "Nelson", "Nevaeh", "Nia",
			"Niall", "Niamh", "Nicholas", "Nick", "Nickolas", "Nicolas",
			"Nicole", "Nikolas", "Nina", "Noah", "Noe", "Noel", "Noelle",
			"Nolan", "Nora", "Noreen", "Norma", "Norman", "Oisin", "Olga",
			"Oliver", "Olivia", "Omar", "Oran", "Orla", "Orlaith", "Orlando",
			"Oscar", "Osvaldo", "Otis", "Owen", "Pablo", "Padraig", "Paige",
			"Pam", "Pamela", "Paola", "Paris", "Parker", "Pat", "Patrice",
			"Patricia", "Patrick", "Patsy", "Patti", "Patty", "Paul", "Paula",
			"Paulette", "Paulina", "Pauline", "Payton", "Payton", "Pedro",
			"Peggy", "Penny", "Perla", "Perry", "Pete", "Peter", "Peyton",
			"Peyton", "Phil", "Philip", "Phillip", "Phoebe", "Phyllis",
			"Piper", "Polly", "Poppy", "Precious", "Preston", "Priscilla",
			"Queenie", "Quentin", "Quiana", "Quincy", "Quinlan", "Quinn",
			"Quinton", "Rachael", "Rachel", "Rachelle", "Rafael", "Ralph",
			"Ramon", "Ramona", "Randal", "Randall", "Randolph", "Randy",
			"Raquel", "Raul", "Raven", "Ray", "Raymond", "Reagan", "Rebecca",
			"Rebekah", "Reece", "Reed", "Reese", "Reese", "Regan", "Regina",
			"Reginald", "Reid", "Rena", "Rene", "Rene", "Renee", "Rex",
			"Reynaldo", "Rhonda", "Rhys", "Rian", "Ricardo", "Richard", "Rick",
			"Rickey", "Rickie", "Ricky", "Riley", "Riley", "Rita", "Rob",
			"Robbie", "Robby", "Robert", "Roberta", "Roberto", "Robin",
			"Robin", "Robyn", "Rochelle", "Rocky", "Rod", "Roderick", "Rodger",
			"Rodney", "Rodolfo", "Rodrigo", "Rogelio", "Roger", "Roisin",
			"Roland", "Rolando", "Roman", "Ron", "Ronald", "Ronan", "Ronda",
			"Ronnie", "Ronny", "Roosevelt", "Rory", "Rosa", "Rosalind", "Rose",
			"Rosemarie", "Rosemary", "Rosie", "Ross", "Roxanne", "Roy",
			"Ruairi", "Ruben", "Ruby", "Rudolph", "Rudy", "Rufus", "Russell",
			"Rusty", "Ruth", "Ryan", "Rylan", "Rylee", "Ryleigh", "Rylie",
			"Sabrina", "Sadhbh", "Sadie", "Sage", "Sally", "Salvador",
			"Salvatore", "Sam", "Samantha", "Sammy", "Samuel", "Sandra",
			"Sandy", "Santiago", "Saoirse", "Sara", "Sarah", "Sasha", "Saul",
			"Savanna", "Savannah", "Sawyer", "Scarlett", "Scot", "Scott",
			"Scottie", "Scotty", "Sean", "Sebastian", "Sebestian", "Selena",
			"Serena", "Serenity", "Sergio", "Seth", "Shane", "Shania",
			"Shannon", "Shannon", "Shari", "Sharon", "Shaun", "Shauna",
			"Shawn", "Shawn", "Shawna", "Shayla", "Sheila", "Shelby",
			"Sheldon", "Shelia", "Shelley", "Shelly", "Sheri", "Sherman",
			"Sherri", "Sherrie", "Sherry", "Sheryl", "Shirley", "Sidney",
			"Sidney", "Sienna", "Sierra", "Silas", "Simon", "Sinead", "Skye",
			"Skylar", "Skylar", "Skyler", "Skyler", "Sofia", "Solomon",
			"Sondra", "Sonia", "Sonja", "Sonya", "Sophia", "Sophie", "Spencer",
			"Stacey", "Stacey", "Staci", "Stacie", "Stacy", "Stacy", "Stanley",
			"Stella", "Stephan", "Stephanie", "Stephen", "Sterling", "Steve",
			"Steven", "Stevie", "Stewart", "Stuart", "Sue", "Summer", "Susan",
			"Susanne", "Susie", "Suzanne", "Suzette", "Sydney", "Sylvester",
			"Sylvia", "Tabitha", "Tadhg", "Tahlia", "Talia", "Tamara",
			"Tamera", "Tami", "Tamia", "Tammi", "Tammie", "Tammy", "Tamra",
			"Tania", "Tanner", "Tanya", "Tara", "Taryn", "Tate", "Tatiana",
			"Tatum", "Tayla", "Taylah", "Taylor", "Taylor", "Ted", "Teddy",
			"Terence", "Teresa", "Teri", "Terrance", "Terrell", "Terrence",
			"Terri", "Terrie", "Terry", "Terry", "Tessa", "Thelma", "Theodore",
			"Theresa", "Therese", "Thomas", "Tia", "Tiana", "Tiffany", "Tilly",
			"Tim", "Timmy", "Timothy", "Tina", "Toby", "Tod", "Todd", "Tom",
			"Tomas", "Tommie", "Tommy", "Toni", "Tonia", "Tony", "Tonya",
			"Tori", "Tracey", "Tracey", "Traci", "Tracie", "Tracy", "Tracy",
			"Travis", "Trent", "Trenton", "Trevon", "Trevor", "Trey", "Tricia",
			"Trina", "Trinity", "Trisha", "Tristan", "Tristen", "Triston",
			"Troy", "Trudy", "Tucker", "Ty", "Tyler", "Tyrese", "Tyrone",
			"Tyson", "Ulysses", "Una", "Uriah", "Uriel", "Ursula", "Valarie",
			"Valeria", "Valerie", "Van", "Vance", "Vanessa", "Vaughn", "Velma",
			"Vera", "Vernon", "Veronica", "Vicki", "Vickie", "Vicky", "Victor",
			"Victoria", "Vince", "Vincent", "Virgil", "Virginia", "Vivian",
			"Viviana", "Vonda", "Wade", "Walker", "Wallace", "Walter", "Wanda",
			"Warren", "Wayne", "Wendell", "Wendi", "Wendy", "Wesley", "Weston",
			"Whitney", "Wilbert", "Wilbur", "Will", "Willard", "William",
			"Willie", "Willis", "Wilma", "Wilson", "Wyatt", "Xander", "Xavier",
			"Xaviera", "Xena", "Yahir", "Yasmin", "Yasmine", "Yehudi",
			"Yesenia", "Yestin", "Yolanda", "York", "Yvette", "Yvonne", "Zac",
			"Zachariah", "Zachary", "Zachery", "Zackary", "Zackery", "Zak",
			"Zander", "Zane", "Zara", "Zebulon", "Zed", "Zeke", "Zelda",
			"Zion", "Zoe", "Zoey", "Zuri" };

	private static final String[] lastNames = { "Landon", "Hamilton", "King",
			"Koontz", "Rice", "Eddings", "Egger", "Card", "Baldwin", "Archer",
			"Chast", "Teller", "Pratchett", "Maguire ", "Green", "Black",
			"Anderson ", "McCrumb", "Wodehouse", "Larson ", "de Lint", "Hand ",
			"Moon", "Flewelling", "Peck", "Bragg", "Noble", "O\'Connell",
			"Webster", "Dalton", "Roberts", "Sparks", "Atwood", "Ryman",
			"Irving", "Heinlein", "Ambrose", "Adler", "Compton", "Robbins",
			"Shelley", "Orwell ", "Golden", "Gardener", "Rand", "Moore",
			"Twain", "Delderfield ", "Paulsen", "Fisher", "Berg", "Finch",
			"Perry ", "Howe", " Bellow", "Wiesel", "Lynn", "Kidd", "Thackeray",
			"Dreiser", "Zelazny", "Harris", "Wolf", "MacLeod", "Jacobs",
			"Fairbanks", "London", "Wilhelm", "Langton", "Wilson", "Law",
			"Sands", "Dunn", "Gregory", "Huxley", "Wibberley", "Yates",
			"Keats", "Bradbury", "Rushdie", "Cabot", "Hobb", "Quindlen",
			"Armstrong", "Vreeland", "Herbert", "Williamson ", "Heck",
			"Flanagan", "Moorcock", "Nix", "Klein", "Brown", "Ginsberg",
			"Plath", "Sexton", "Carroll", "Berryman", "Kay", "Penman",
			"Cornwell", "Ballard", "Norberg", "Gaiman ", "Robinson", "Stokes",
			"Dahl", "Asimov", "Angelou", "Gibbons", "Forster", "Lynch",
			"Scott", "Lovejoy", "Loveless", "Ferguson", "Lustbader ", "Hooper",
			"Collins", "McKean", "Stephenson ", "Donnelly", "Fforde", "Haddon",
			"Padgett", "Tiernan", "Davies", "Shreve", "Wells", "Block",
			"Goldberg", "Kingsolver", "Wilde", "Harding", "Zigman", "Wallace",
			"Showalter", "Bracken", "James", "Postman", "Salinger", "Waugh",
			"Eliot", "Downing", "Silverberg", "Cobbold", "McKinley",
			"Callahan ", "Sacks", "Starbuck ", "Anthony ", "Reilly ", "Noon",
			"Jackson ", "Register ", "Pierce ", "Hoyt ", "Woodworth ", "Albom",
			"Cormier", "Keefe", "Miller", "Hughes", "Stewart ", "Austen",
			"Tyler", "Hoffman", "North ", "Chopin", "Barry", "Small", "Gluck ",
			"Bronte", "Heller", "Dickens ", "Alcott", "Hardy", "Marquez",
			"Montgomery ", "Fitzgerald ", "Dumas ", "Orwell ", "Burnett",
			"Magorian", "Ransome", "Colfer", "Blackman ", "Sewell",
			"McCollough", "Blyton", "Susskind ", "Tressell ", "Joyce ",
			"Wilson", "Feist", "Puzo", "Auel", "Coelho ", "Garland", "Stoker",
			"Cormac", "Horowitz", "Forsyth", "Townsend", "Hugo", "Clavell",
			"Galsworthy", "Wyndham", "Danielewski", "Byatt", "Remarque",
			"Atkinson", "Hornby", "Charriere", "McEwan", "Kesey", "Conrad",
			"Proulx", "Blackmore", "Eco", "Bach", "Courtenay", "Stine",
			"Spyri", "Lawrence", "Kundera", "Parsons", "Mistry", "Carle",
			"Jordan", "Helprin", "Foucault", "Boswell", "Shaffer",
			"Steingarten", "Rilke", "Paterson", "Moliere", "Kafka", "Miller",
			"Gunther", "Ibsen", "Wharton", "Read", "Bradley", "Hyde",
			"Donaldson", "Toole", "Wong", "Niven", "Baum", "Jester", "Tan",
			"Child", "St. George", "Banan", "Ketchum", "Palahniuk", "Dobyns",
			"Chalker", "Lackey", "Love", "Morrison", "Demille", "Brust",
			"Kurtz", "Wouk", "Tzu", "Lowry ", "Le Guin ", "Butler ", "Bujold",
			"Russell ", "Hill ", "Blume ", "Milne", "Pullman", "Banks ",
			"Hearn ", "Allan", "White", "Holder", "Brite", "Johns", "Clarke",
			"Grimes", "Walton" };

	private static final String[] countries = { "United Kingdom",
			"United States", "The Netherlands", "Germany", "Belgium" };

	public KidsList() {
		kids = new ArrayList<Kid>();

		for (int i = 0; i < 1000; i++) {
			kids.add(new Kid(getRandomFirstName(), getRandomLastName(),
					getRandomBirthDate(), getRandomBraveness(),
					getRandomCountry(), getRandomScareDate()));
		}
	}

	public List<Kid> getKids() {
		return kids;
	}

	private double getRandomBraveness() {
		return Math.random() * 10.0;
	}

	private Date getRandomBirthDate() {
		return getRandomDateBetweenNowAnd(365 * 12, Calendar.DAY_OF_YEAR);
	}

	private String getRandomFirstName() {
		int random = (int) (Math.random() * firstNames.length);
		return firstNames[random];
	}

	private String getRandomLastName() {
		int random = (int) (Math.random() * lastNames.length);
		return lastNames[random];
	}

	private String getRandomCountry() {
		int random = (int) (Math.random() * countries.length);
		return countries[random];
	}

	private Date getRandomScareDate() {
		return getRandomDateBetweenNowAnd(365, Calendar.DAY_OF_YEAR);
	}

	private Date getRandomDateBetweenNowAnd(int number, int field) {
		int random = (int) (Math.random() * number);

		Calendar result = Calendar.getInstance();

		result.add(field, 0 - random);

		return result.getTime();
	}
}
